// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TVmeMpx201aModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TVmeDaughterBoardMemoryModule.hh"

TVmeMpx201aModule::TVmeMpx201aModule( Tint baseaddress, Tint nblock, Tint mapsize )
  : TVmeModule( 0, baseaddress, mapsize, tA16D32 ), theMemoryModule( 0 )
{
  // block counter 1block=2048sample
  SetNumberOfBlock( nblock );
  //setBit( (TUshort*)( base + BLOCK_COUNT ),  |= 0x0001;
  //zz = *( (ushort*)( base + BLOCK_COUNT ) );
  //showbit( zz, "BLOCK_COUNT" );



  // transient mode
  //*( (ushort*)( base + CONTROL_STATUS ) ) |= 0x0020;
  //*( (ushort*)( base + CONTROL_STATUS ) ) &= 0xfeff;
  //  SetDataCaptureMode( tTransientMode );


  // event synchronization
  //*( (ushort*)( base + CONTROL_STATUS ) ) |= 0x0080;
  //*( (ushort*)( base + CONTROL_STATUS ) ) &= 0xffbf;
  //  SetEventSynchronisationMode( tExternalSynchronisationMode );

  // VME OFFSET ADDRESS
  //*( (ushort*)( base + VME_OFFSET_ADDRESS ) ) = 0xff00;
  SetOffsetAddressForDaughterBoard( 0xff00 );


  // enable memory access
  //*( (ushort*)( base + CONTROL_STATUS ) ) |= 0x8000;
  //EnableAccessToDaughterBoard();

  TUlong offset = GetOffsetAddressForDaughterBoard();
  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( offset, 0xf000, nblock * tBlock );

}

TVmeMpx201aModule::~TVmeMpx201aModule()
{
  delete theMemoryModule;
}

Tint TVmeMpx201aModule::Clear()
{
  theMemoryModule -> Clear();
  setBit( (TUshort*)( theModuleBaseAddress + CONTROL_STATUS ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CONTROL_STATUS ), 0, 0 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeMpx201aModule::Update()
{
  return( Clear() );
}

Tint TVmeMpx201aModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeMpx201aModule::FillData( const TDataSegment& segment )
{
  theMemoryModule -> FillData( segment );
  return;
}

Tvoid TVmeMpx201aModule::FillData( const TDataElement& element )
{
  theMemoryModule -> FillData( element );
}
