// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<segment ID>" << Tendl;
    return( -1 );
  }
  const Tint findsegID = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    for ( Tint i = 0; i < (Tint)record.size(); i ++ ) {
      TDataSection section = record[ i ];
      for ( Tint j = 0; j < (Tint)section.size(); j ++ ) {
	TDataSegment segment = section[ j ];
	if ( segment.GetID() == findsegID ) {
	  for ( Tint k = 0; k < (Tint)segment.size(); k ++ ) {
	    TDataElement element = segment[ k ];
	    switch ( element.GetElementType() ) {
	      case tTypeInt:
		Tcout << *( (Tint*)( element.GetData() ) ) << Tspace;
		break;
	      case tTypeString:
		Tcout << *( (Tstring*)( element.GetData() ) ) << Tspace;
		break;
	      case tTypeDouble:
		Tcout << *( (Tdouble*)( element.GetData() ) ) << Tspace;
		break;
	      default:
		Tcerr << "WARNNING: NOT SUPPORTED DATA !!!" << Tspace;
		break;
	    }
	  }
	  Tcout << Tendl;
	}
      }
    }
  }

  delete ifile;
  return( 0 );
}
