// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataElement.hh"
#include "TOutputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  TOutputObjectFile* ofile = new TOutputObjectFile( filename );
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataElement element( &i, tTypeInt, i );
    ofile -> WriteData( element );
    datasize1 += element.GetDataSize();
    datasize2 += ofile -> GetDataSize();
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize1 << Tslash << datasize2;
  Tcout << Tspace << "byte data has been written down " << filename << Tendl;
  Tcout << Tendl;

  delete ofile;
  return( 0 );
}
