// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TANALYSISDATAEXTRACTOR_HH
#define __TANALYSISDATAEXTRACTOR_HH

#include "TGlobals.hh"
#include "TMultipleData.hh"

class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

//IDȥͥ뤫ǡ̤ǽץƥƥäǤۤ
class TAnalysisDataExtractor
{

  protected:
    TMultipleData theMultipleData;

  public:
    TAnalysisDataExtractor();
    TAnalysisDataExtractor( const TAnalysisDataExtractor& right );

  protected:
    virtual ~TAnalysisDataExtractor();

  public:
    virtual Tvoid Extract( const TDataRecord& record ) = 0;
    //virtual Tvoid Extract( const TDataSection& section ) = 0;
    //virtual Tvoid Extract( const TDataSegment& segment ) = 0;
    //virtual Tvoid Extract( const TDataElement& element ) = 0;

  public:
    const TAnalysisDataExtractor& operator=( const TAnalysisDataExtractor& right );
    Tbool operator==( const TAnalysisDataExtractor& right ) const;
    Tbool operator!=( const TAnalysisDataExtractor& right ) const;

  public:
    const TMultipleData& GetMultipleData() const;
    Tvoid SetMultipleData( const TMultipleData& mdata );

};

inline const TMultipleData& TAnalysisDataExtractor::GetMultipleData() const
{
  return( theMultipleData );
}

inline Tvoid TAnalysisDataExtractor::SetMultipleData( const TMultipleData& mdata )
{
  theMultipleData = mdata;
  return;
}

#endif
