// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRootAnalyser.hh"
#include "TDataRecord.hh"
#include "TAnalysisDataExtractor.hh"
#include "TMultipleData.hh"

static TApplication app( Tproject.c_str(), 0, 0 );

//TApplication* TRootAnalyser::theApplication = 0;
//󥰥ȥȤ߷פɬפ
TRootAnalyser::TRootAnalyser( Tint width, Tint height )
  : thePointID( 0 ), theSamplingRate( 0 ), theCanvas( Tproject.c_str(), Tproject.c_str(), width, height )
{;}

TRootAnalyser::~TRootAnalyser()
{;}

Tvoid TRootAnalyser::Fill1DHistogram( TRoot1DHistogram& hist, TDataRecord& record, TAnalysisDataExtractor& extractor )
{
  extractor.Extract( record );
  TMultipleData mdata = extractor.GetMultipleData();
  for ( Tsize_t i = 0; i < mdata.size(); i ++ )
    hist.Fill( ( mdata[ i ] )[ 0 ] );
  return;
}

Tvoid TRootAnalyser::FillGraph( TRootGraph& graph, TDataRecord& record, TAnalysisDataExtractor& extractor )
{
  extractor.Extract( record );
  TMultipleData mdata = extractor.GetMultipleData();
  for ( Tsize_t i = 0; i < mdata.size(); i ++ ) {
    graph.SetPoint( thePointID, ( mdata[ i ] )[ 0 ], ( mdata[ i ] )[ 1 ] );
    thePointID ++;
  }
  return;
}

// Tvoid TRootAnalyser::ShowNewCanvas( const Tstring& cvname, const Tstring& showstr, Tint width, Tint height )
// {
//   TCanvas canvas( cvname.c_str(), showstr.c_str(), width, height );
//   theCanvasList.push_back( canvas );
//   return;
// }

Tvoid TRootAnalyser::Update()
{
//   for ( Tsize_t i = 0; i < theCanvasList.size(); i ++ ) {
//     theCanvasList[ i ].Modified();
//     theCanvasList[ i ].Update();
//   }
  theCanvas.Modified();
  theCanvas.Update();
  gSystem -> ProcessEvents();
  usleep( theSamplingRate );
  return;
}

Tvoid TRootAnalyser::Run( Tbool ret )
{
  app.Run( ret );
  return;
}
