// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TROOTANALYSER_HH
#define __TROOTANALYSER_HH

#include "TGlobals.hh"
//#include "TAnalyser.hh"
#include "TRoot1DHistogram.hh"
#include "TRootGraph.hh"
#include "TRootCanvas.hh"
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 

class TDataRecord;
class TAnalysisDataExtractor;

class TRootAnalyser
//  : public TAnalyserȤꤢROOT˷ᤦ
{

  private:
    //٤ˤʥХΩ夲ƥåץǡȤɡ
    //ˡʤΤǡȤꤢΥХǤ뤳Ȥˤ
    //,餱äĤ߷פ褦
    //TRootCanvasList theCanvasList;
    //closeǥܡ
    Tint thePointID;
    Tint theSamplingRate;
    TRootCanvas theCanvas;

  private:
    //static TApplication* theApplication;

  public:
    TRootAnalyser( Tint width = 640, Tint height = 480 );
    ~TRootAnalyser();

  public:
    //DataRecordʳȤ٤
    Tvoid Fill1DHistogram( TRoot1DHistogram& hist, 
			   TDataRecord& record, 
			   TAnalysisDataExtractor& extractor );

    Tvoid FillGraph( TRootGraph& graph,
		     TDataRecord& record,
		     TAnalysisDataExtractor& extractor );
    //Tvoid ShowNewCanvas( const Tstring& cvname = "", const Tstring& showstr = "", Tint width = 640, Tint height = 480 );
    Tvoid Update();
    Tvoid DivideCanvas( Tint x, Tint y );
    Tvoid MoveCanvas( Tint ptr );
    Tvoid Run( Tbool ret = Tfalse );

};

inline Tvoid TRootAnalyser::DivideCanvas( Tint x, Tint y )
{
  theCanvas.Divide( x, y );
  return;
}

inline Tvoid TRootAnalyser::MoveCanvas( Tint ptr )
{
  theCanvas.cd( ptr );
  return;
}

#endif
