// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TRUN_HH
#define __TRUN_HH

#include "TGlobals.hh"
#include "TEventList.hh"

class TRun
{

  private:
    Tint theRunID;
    TEventList theEventList;

  public:
    TRun();
    TRun( const TRun& right );
    virtual ~TRun();

  public:
    const TRun& operator=( const TRun& right );
    Tbool operator==( const TRun& right ) const;
    Tbool operator!=( const TRun& right ) const;

  public:
    Tint GetRunID() const;
    const TEventList& GetEventList() const;

    Tvoid SetRunID( Tint runid );
    Tvoid SetEventList( const TEventList& evtlist );

  public:
    Tvoid Clear();

};

inline Tint TRun::GetRunID() const
{
  return( theRunID );
}

inline const TEventList& TRun::GetEventList() const
{
  return( theEventList );
}

inline Tvoid TRun::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid TRun::SetEventList( const TEventList& evtlist )
{
  theEventList = evtlist;
  return;
}

#endif
