#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define MEM_SZ 4096

struct shared_use_st
{
  int written_by_you;
  char some_text[BUFSIZ];
};

int main()
{
  int running = 1;
  void* shared_memory = (void *)0;
  struct shared_use_st* shared_stuff;
  int shmid;

  srand( (unsigned int)getpid() );
  
  shmid = shmget( (key_t)1234, MEM_SZ, 0666 | IPC_CREAT);

  if (shmid == -1) {
    cerr << "shmget failed" << endl;
    exit(EXIT_FAILURE);
  }

  shared_memory = shmat(shmid, (void *)0, 0);
  if (shared_memory == (void *)-1) {
    cerr << "shmat failed" << endl;
    exit(EXIT_FAILURE);
  }

  cout << "Memory attached at " << (int)shared_memory << endl;
  
  shared_stuff = (struct shared_use_st *)shared_memory;
  shared_stuff->written_by_you = 0;
  while (running) {
    if (shared_stuff->written_by_you) {
      cout << "You wrote: " << shared_stuff -> some_text;
      printf("You wrote: %s", shared_stuff->some_text);
      sleep( rand() % 4 ); // make the other process wait for us !
      shared_stuff->written_by_you = 0;
      if (strncmp(shared_stuff->some_text, "end", 3) == 0) {
	running = 0;
      }
    }
  }

  if (shmdt(shared_memory) == -1) {
    cerr << "shmat failed" << endl;
    exit(EXIT_FAILURE);
  }

  if (shmctl(shmid, IPC_RMID, 0) == -1) {
    cerr << "shmctl(IPC_RMID) failed" << endl;
    exit(EXIT_FAILURE);
  }

  exit(EXIT_SUCCESS);
}

        

