// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAnalysisDataExtractor.hh"

TAnalysisDataExtractor::TAnalysisDataExtractor( Tint length )
  : theMaxDataListLength( length ), theDataList( length, 0.0 )
{;}

TAnalysisDataExtractor::TAnalysisDataExtractor( const TAnalysisDataExtractor& right )
  : theMaxDataListLength( right.theMaxDataListLength ),
    theDataList( right.theDataList )
{;}

TAnalysisDataExtractor::~TAnalysisDataExtractor()
{;}

const TAnalysisDataExtractor& TAnalysisDataExtractor::operator=( const TAnalysisDataExtractor& right )
{
  theMaxDataListLength = right.theMaxDataListLength;
  theDataList = right.theDataList;
  return( *this );
}

Tbool TAnalysisDataExtractor::operator==( const TAnalysisDataExtractor& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( theMaxDataListLength == right.theMaxDataListLength );
  ret &= ( theDataList == right.theDataList );
  return( ret );
}

Tbool TAnalysisDataExtractor::operator!=( const TAnalysisDataExtractor& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( theMaxDataListLength != right.theMaxDataListLength );
  ret &= ( theDataList != right.theDataList );
  return( true );
}
