// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TANALYSISDATAEXTRACTOR_HH
#define __TANALYSISDATAEXTRACTOR_HH

#include "TGlobals.hh"

class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;


//IDȥͥ뤫ǡ̤ǽץƥƥäǤۤ
class TAnalysisDataExtractor
{

  public:
    enum { tMaxListLength = 16 };

  protected:
    Tint theMaxDataListLength;
    TdoubleList theDataList;

  public:
    TAnalysisDataExtractor( Tint length = tMaxListLength );
    TAnalysisDataExtractor( const TAnalysisDataExtractor& right );

  protected:
    virtual ~TAnalysisDataExtractor();

  public:
    virtual Tvoid Extract( const TDataRecord& record ) = 0;
    //virtual Tvoid Extract( const TDataSection& section ) = 0;
    //virtual Tvoid Extract( const TDataSegment& segment ) = 0;
    //virtual Tvoid Extract( const TDataElement& element ) = 0;

  public:
    const TAnalysisDataExtractor& operator=( const TAnalysisDataExtractor& right );
    Tbool operator==( const TAnalysisDataExtractor& right ) const;
    Tbool operator!=( const TAnalysisDataExtractor& right ) const;

  public:
    Tint GetMaxDataListLength() const;
    const TdoubleList& GetDataList() const;
    Tvoid SetMaxDataListLength( Tint length );
    Tvoid SetDataList( const TdoubleList& list );

};

inline Tint TAnalysisDataExtractor::GetMaxDataListLength() const
{
  return( theMaxDataListLength );
}

inline const TdoubleList& TAnalysisDataExtractor::GetDataList() const
{
  return( theDataList );

}

inline Tvoid TAnalysisDataExtractor::SetMaxDataListLength( Tint length )
{
  theMaxDataListLength = length;
  return;
}

inline Tvoid TAnalysisDataExtractor::SetDataList( const TdoubleList& list )
{
  theDataList = list;
  return;
}

#endif
