// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOUTPUTOBJECTSHAREDMEMORY_HH
#define __TOUTPUTOBJECTSHAREDMEMORY_HH

#include "TGlobals.hh"
#include "TObjectSharedMemory.hh"
#include "TOutputObjectStream.hh"
#include "TSignalClient.hh"
#include "TSignalHandler.hh"

class TStreamableObject;
class TObjectFilter;
class TSignalHandler;

class TOutputObjectSharedMemory
  : public TObjectSharedMemory, public TOutputObjectStream, 
    public TSignalClient
{

  private:
    TSignalHandler* theSigIntHandler;
    TSignalHandler* theSigSegvHandler;

  public:
    TOutputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TOutputObjectSharedMemory( TObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TOutputObjectSharedMemory();

  public:
    const TSignalHandler* GetSigIntHandler() const;
    const TSignalHandler* GetSigSegvHandler() const;

  public:
    Tint WriteData( TStreamableObject& object );
    Tvoid CatchSignal( Tint signal );

};

const TSignalHandler* TOutputObjectSharedMemory::GetSigIntHandler() const
{
  return( theSigIntHandler );
}

const TSignalHandler* TOutputObjectSharedMemory::GetSigSegvHandler() const
{
  return( theSigSegvHandler );
}

inline Tvoid TOutputObjectSharedMemory::CatchSignal( Tint signal )
{
  Detach();
  Remove();
  delete theSigIntHandler;
  delete theSigSegvHandler;
  exit( 0 );
}

#endif
