// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectSharedMemory.hh"

TOutputObjectSharedMemory::TOutputObjectSharedMemory( const Tstring& projectName, Tint maxSize )
  : TObjectSharedMemory( projectName ),
    TOutputObjectStream( tSharedMemoryStream ),
    theMaxMemorySize( maxSize )
{
  Tstring sem_proj = "/tmp/" + theProjectName;
  Tstring shm_proj = semp;
  Tstring nclients = shmp + "nclients";



  theSharedMemoryID = 
    shmget( ftok( shm_proj.c_str(), Tkey ),
	    theMaxMemorySize, 0666 | IPC_CREAT );
  void* mem = shmat( theSharedMemoryID, 0, 0 );
  memset( mem, 0, (Tsize_t)theMaxMemorySize );

  theNumberOfClientsID = 
    shmget( ftok( nclients.c_str(), Tkey ), 
	    Tsizeof( TUshort ), 0666 | IPC_CREAT );

  TUshort* nc = (TUshort* )shmat( theNumberOfClientsID, 0, 0 );
  *nc = 0;
  theNumberOfClients = *nc;
  //theNumberOfClientsϾ̥饹ΥФˤ٤

  theSemaphoreID = 
    semget( ftok( sem_proj.c_str(), Tkey ), 
	    tNumberOfSemaphores, 0666 | IPC_CREAT );
  
  Tshort initval[ tNumberOfSemaphores ] 
    = { (Tshort)(theNumberOfClients), (Tshort)(theNumberOfClients) };

  if ( semctl( theSemaphoreID, 0, SETALL, &initval ) == -1 )
    perror( "TOutputObjectSharedMemory::TOutputObjectSharedMemory" );

}

TOutputObjectSharedMemory::TOutputObjectSharedMemory( TObjectFilter* filter )
  : TObjectSharedMemory(), TOutputObjectStream( filter, tSharedMemoryStream )
{;}

TOutputObjectSharedMemory::~TOutputObjectSharedMemory()
{;}

Tvoid TOutputObjectSharedMemory::remove()
{
  if ( semctl( theSemaphoreID, 0, IPC_RMID, 0 ) == -1 )
    perror( "TOutputObjectSharedMemory::remove" );
  
  if ( shmctl( theSharedMemoryID, IPC_RMID, 0 ) == -1 )
    perror( "TOutputObjectSharedMemory::remove" );

  if ( shmctl( theNumberOfClientsID, IPC_RMID, 0 ) == -1 )
    perror( "TOutputObjectSharedMemory::remove" );

  return;
}

Tint catchSignal( int signal )
{
  Tcout << "get the signal " << sig << ", remove IPC resources." << Tendl;
  remove();
  exit( 0 );
}
