// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "MyExtractorCH3.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

static const Tstring name = "CH3";
static const Tobject_t type = tObject1DHistogram;
static const Tint nevents = 1;
static const Tint usec = 0;

MyExtractorCH3::MyExtractorCH3()
  : TExtractor( name, type, nevents, usec ), theInputObjectFile( 0 )
{
  theInputObjectFile = new TInputObjectFile( "adc.obj" );
}

MyExtractorCH3::~MyExtractorCH3()
{
  delete theInputObjectFile;
}

Tvoid MyExtractorCH3::Extract()
{
  TDataRecord record;
  TDataElement element;
  TDataElementList list;
  //Tint id[ 3 ] = { 1100, 1100, 3 };
  if ( theInputObjectFile -> ReadData( record ) != 0 ) {
    //element = FindDataElement( record, id );
    element = FindDataElement( record, 1100, 1100, 3 );
    if ( DoesDataFound() ) {
      list.push_back( element );
      FillMatrix( list );
    }
  }
  return;
}
