// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "Ex1DHistogramExtractor.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

Ex1DHistogramExtractor::Ex1DHistogramExtractor()
  : TAnalysisDataExtractor()
{;}

Ex1DHistogramExtractor::~Ex1DHistogramExtractor()
{;}

Tvoid Ex1DHistogramExtractor::Extract( const TDataRecord& record )
{
  static const Tint findsegID = 1110;
  static const Tint ch = 2;
  TDataSection section;
  TDataSegment segment;
  TDataElement element;
  Tint databuf;
  TdoubleList linebuf;
  TMultipleData mdata;

  for ( Tsize_t i = 0; i < record.size(); i ++ ) {
    section = record[ i ];
    for ( Tsize_t j = 0; j < section.size(); j ++ ) {
      segment = section[ j ];
      if ( segment.GetID() == findsegID ) {
	element = segment[ ch ];
	databuf = *( (Tint*)( element.GetData() ) );
	linebuf.push_back( (Tdouble)databuf );
	mdata.push_back( linebuf );
	theMultipleData = mdata;
      }
    }
  }

  return;
}
