// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

//    * Data Section, ID: 1200  Capacity: 1  Entry: 1
//      * Data Segment, ID: 1210  Capacity: 1  Entry: 1
//        * Data Element, ID: 0  Primitives: 61440  Type: 7/Integer(16)  Data: 13632, 13728, 13728, 13760, 13744, 13728, 13712, 13696, 13616, 13584, 13504, 13424, 13312, 13248, 13168, 13024

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];


  const Tint findsegID = 1210;
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    for ( Tsize_t i = 0; i < record.size(); i ++ ) {
      TDataSection section = record[ i ];
      for ( Tsize_t j = 0; j < section.size(); j ++ ) {
	TDataSegment segment = section[ j ];
	if ( segment.GetID() == findsegID ) {
	  for ( Tsize_t k = 0; k < segment.size(); k ++ ) {
	    TDataElement element = segment[ k ];

	    
	    Tint narray = element.GetNumberOfPrimitives();
	    //element.GetElementType()
	    TUshort* data = (TUshort*)( element.GetData() );

	    TUshort databuf;
	    for ( Tint n = 0; n < narray; n ++ ) {
	      databuf = *data;
	      Tint sign = databuf & 0x8000;
	      sign = sign >> 15;
	      if ( sign == 1 ) {// negative value
		databuf &= 0x7fff;
		databuf = databuf >> 4;
	      } else if ( sign == 0 ) {// positive value
		databuf = databuf >> 4;
		databuf += 0x07ff;
	      } else {
		Tcerr << "failed.." << Tendl;
	      }


	      Tcout << n << " " << databuf << Tendl;
	      data ++;
	    }

	  }
	}
      }
    }
  }

  delete ifile;
  return( 0 );
}
