// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "DummyModuleDefinition.hh"

static const Tint list1ID = 1000;
static const Tint list2ID = 2000;

DummyModuleDefinition::DummyModuleDefinition()
  : theReadoutList1( list1ID ), theReadoutList2( list2ID ), 
    theScaler(), theTimer(), theClock(), theFlashAdc( 1, 100 ),
    theRunInfo( 0 )
{
  TReadoutSection sec1( 1100 );
  TReadoutSegment seg1( &theScaler, 1100 );
  sec1.push_back( seg1 );
  theReadoutList1.push_back( sec1 );


  TReadoutSection sec2( 2100 );
  TReadoutSegment seg2( &theClock, 2200 );
  TReadoutSegment seg3( &theTimer, 2300 );
  TReadoutSegment seg4( &theFlashAdc, 2400 );
  sec2.push_back( seg2 );
  sec2.push_back( seg3 );
  sec2.push_back( seg4 );
  theReadoutList2.push_back( sec2 );

  theRunInfo = new TSoftwareRunInformationModule();
}

DummyModuleDefinition::~DummyModuleDefinition()
{
  delete theRunInfo;
}

const TReadoutList& DummyModuleDefinition::GetReadoutList() const
{
  time_t now = 0;
  time( &now );
  if ( now % 2 == 0 )
    return( theReadoutList1 );
  return( theReadoutList2 );
}

Tvoid DummyModuleDefinition::Update()
{
  theScaler.Update();
  theTimer.Update();
  theClock.Update();
  theFlashAdc.Update();
  return;
}
