// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRun.hh"
#include "TOutputObjectFile.hh"
#include "DummyRunAction.hh"

DummyRunAction::DummyRunAction()
  : theOutputFile( 0 )
{;}

DummyRunAction::~DummyRunAction()
{;}

Tvoid DummyRunAction::BeginOfRunAction( TRun& aRun )
{
  Tint runid = aRun.GetRunID();
  Tcout << "run #" << runid << " begin." << Tendl;

  Tstring filename = "dummydaq-run";
  Tstring runidstr = aRun.GetRunIDofString();
  if ( runid < 10 )
    filename += "00";
  else if ( runid < 100 )
    filename += "0";
  filename += runidstr + ".drec";

  theOutputFile = new TOutputObjectFile( filename );
  Tcout << "event data is output into " << filename << Tendl;
  return;
}

Tvoid DummyRunAction::EndOfRunAction( TRun& aRun )
{
  Tcout << "run #" << aRun.GetRunID() << " end." << Tendl;
  delete theOutputFile;
  return;
}

Tvoid DummyRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}
