// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAnalysisStatusTable.hh"

TAnalysisStatusTable::TAnalysisStatusTable()
  : TAnalysisStatusList()
{
  Clear();
}

TAnalysisStatusTable::~TAnalysisStatusTable()
{;}

Tostream& operator<<( Tostream& tos, const TAnalysisStatusTable& right )
{
  for ( Tint i = 0; i < (Tint)right.size(); i ++ )
    tos << right[ i ] << Tendl;
  tos << Tflush;
  return( tos );
}

Tvoid TAnalysisStatusTable::AddAnalysisStatus( const TAnalysisStatus& status )
{
  Tstring id = status.GetID();
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound ) {
    push_back( status );
  } else {
    Tstring head = "TAnalysisStatusTable::AddAnalysisStatus: ";
    Tcerr << head << "table already has a this status, " << status << Tendl;
  }
  return;
}

Tvoid TAnalysisStatusTable::RemoveAnalysisStatus( const Tstring& id )
{
  Tint position = FindAnalysisStatus( id );
  if ( position != tNotFound ) {
    erase( begin() + position );
  } else {
    Tstring head = "TAnalysisStatusTable::RemoveAnalysisStatus: ";
    Tcerr << head << id << " doesn't not found in this table." << Tendl;
  }
  return;
}

Tint TAnalysisStatusTable::FindAnalysisStatus( const Tstring& id ) const
{
  Tint position = tNotFound;
  for ( Tint i = 0; i < (Tint)size(); i ++ ) {
    if ( ( (*this)[ i ] ).GetID() == id ) {
      position = i;
      break;
    }
  }
  return( position );
}

Tvoid TAnalysisStatusTable::Clear()
{
  clear();
  return;
}

Tstatus_t TAnalysisStatusTable::GetStatus( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( tStatusUnknown );
  return( ( (*this)[ position ] ).GetStatus() );
}

Tvoid TAnalysisStatusTable::SetStatus( const Tstring& id, Tstatus_t status )
{
  Tint position = FindAnalysisStatus( id );
  if ( position != tNotFound ) {
    ( (*this)[ position ] ).SetStatus( status );
  } else {
    Tstring head = "TAnalysisStatusTable::SetStatus: ";
    Tcerr << head << id << " doesn't not found in this table." << Tendl;
  }
  return;
}

Tobject_t TAnalysisStatusTable::GetObjectType( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( tObjectUnknown );
  return( ( (*this)[ position ] ).GetObjectType() );
}

Tstring TAnalysisStatusTable::GetID( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( "" );
  return( ( (*this)[ position ] ).GetID() );
}

Tstring TAnalysisStatusTable::GetDrawableObjectID( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( "" );
  return( ( (*this)[ position ] ).GetDrawableObjectID() );
}

Tstring TAnalysisStatusTable::GetCanvasID( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( "" );
  return( ( (*this)[ position ] ).GetCanvasID() );
}

Tbool TAnalysisStatusTable::HasStatus( const Tstring& id ) const
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( Tfalse );
  return( Ttrue );
}

Tthread_t* TAnalysisStatusTable::GetThreadID( const Tstring& id )
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound )
    return( 0 );
  return( ( (*this)[ position ] ).GetThreadID() );
}

Tvoid TAnalysisStatusTable::SetThreadID( const Tstring& id, Tthread_t thread )
{
  Tint position = FindAnalysisStatus( id );
  if ( position == tNotFound ) {
    Tstring head = "TAnalysisStatusTable::SetThreadID: ";
    Tcerr << head << id << " doesn't not found in this table." << Tendl;
  } else {
    ( (*this)[ position ] ).SetThreadID( thread );
  }
  return;
}
