// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TEXTRACTOR_HH
#define __TEXTRACTOR_HH

#include "TGlobals.hh"
#include "TMatrixElement.hh"
#include "TDataElementList.hh"

class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TExtractor
{

  protected:
    Tstring theExtractorID;
    TMatrixElement theMatrixElement;
    Tint theSamplingRate;
    Tbool theDataFoundStatus;
    Tbool theFillMatrixStatus;

  public:
    TExtractor( const Tstring& id, Tobject_t objecttype, Tint nevents = 0, Tint usec = 0 );
    virtual ~TExtractor();

  public:
    virtual Tvoid Extract() = 0;

  public:
    TDataSection FindDataSection( const TDataRecord& record, Tint sectionid );
    TDataSegment FindDataSegment( const TDataSection& section, Tint segmentid );
    TDataSegment FindDataSegment( const TDataRecord& record, Tint sectionid, Tint segmentid );
    TDataSegment FindDataSegment( const TDataRecord& record, Tint id[ 2 ] );
    TDataElement FindDataElement( const TDataSegment& segment, Tint elementid );
    TDataElement FindDataElement( const TDataRecord& record, Tint sectionid, Tint segmentid, Tint elementid );
    TDataElement FindDataElement( const TDataRecord& record, Tint id[ 3 ] );

  public:
    const TMatrixElement& GetMatrixElement() const;
    TMatrixElement& GetMatrixElement();
    Tvoid SetMatrixElement( const TMatrixElement& matrix );
    const Tstring& GetExtractorID() const;
    Tvoid SetExtractorID( const Tstring& id );
    Tint GetSamplingRate() const;
    Tvoid SetSamplingRate( Tint usec );
    Tbool DoesDataFound() const;
    Tbool DoesMatrixFill() const;
    Tbool DoesExtractSuccess() const;

  public:
    Tvoid FillMatrix( const TDataElementList& list );

  protected:
    Tvoid fillMatrixAs1DHistogram( const TDataElementList& list );
    Tvoid fillMatrixAs2DHistogram( const TDataElementList& list );
    Tvoid fillMatrixAsGraph( const TDataElementList& list );
    Tvoid fillMatrixAsNtuple( const TDataElementList& list );

};

inline const TMatrixElement& TExtractor::GetMatrixElement() const
{
  return( theMatrixElement );
}

inline TMatrixElement& TExtractor::GetMatrixElement()
{
  return( theMatrixElement );
}

inline Tvoid TExtractor::SetMatrixElement( const TMatrixElement& matrix )
{
  theMatrixElement = matrix;
  return;
}

inline const Tstring& TExtractor::GetExtractorID() const
{
  return( theExtractorID );
}

inline Tvoid TExtractor::SetExtractorID( const Tstring& id )
{
  theExtractorID = id;
  return;
}

inline Tbool TExtractor::DoesDataFound() const
{
  return( theDataFoundStatus );
}

inline Tbool TExtractor::DoesMatrixFill() const
{
  return( theFillMatrixStatus );
}

inline Tbool TExtractor::DoesExtractSuccess() const
{
  return( DoesMatrixFill() && DoesDataFound() );
}

inline Tint TExtractor::GetSamplingRate() const
{
  return( theSamplingRate );
}

inline Tvoid TExtractor::SetSamplingRate( Tint usec )
{
  theSamplingRate = usec;
  return;
}

#endif
