// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAnalysisResumeCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring name = "/analysis/resume";
static const Tstring desc = "resume an analysis.";

TAnalysisResumeCommand::TAnalysisResumeCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, name, desc ), TAnalysisCommand( anaman )
{;}

TAnalysisResumeCommand::~TAnalysisResumeCommand()
{;}

Tvoid TAnalysisResumeCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> ResumeAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> ResumeAnalysis( arguments[ i ] );
  }
  return;
}
