// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAnalysisStartCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring name = "/analysis/start";
static const Tstring desc = "start an analysis.";

TAnalysisStartCommand::TAnalysisStartCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, name, desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStartCommand::~TAnalysisStartCommand()
{;}

Tvoid TAnalysisStartCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StartAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StartAnalysis( arguments[ i ] );
  }
  return;
}
