// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TClearRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring name = "/run/clearinfo";
static const Tstring desc = "clear run information in the table.";

TClearRunInformationModuleCommand::TClearRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, name, desc ), TRunInformationModuleCommand( module )
{;}

TClearRunInformationModuleCommand::~TClearRunInformationModuleCommand()
{;}

Tvoid TClearRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TClearRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    theRunInformationModule -> Clear();
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }

  return;
}
