// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDateCommand.hh"

static const Tstring name = "/system/date";
static const Tstring desc = "print date and time information.";

TDateCommand::TDateCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TDateCommand::~TDateCommand()
{;}

Tvoid TDateCommand::Execute( const TstringList& arguments )
{
  static const Tstring format = "%a %b %d %H:%M:%S %Z %Y";
  static const Tsize_t max = 1024;

  Ttime_t time_now;
  time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tchar* strbuf = new Tchar[ max ];
  strftime( strbuf, max, format.c_str(), tm_now );
  Tcout << strbuf << Tendl;
  delete [] strbuf;
  return;
}
