// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TInitializeRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring name = "/run/initinfo";
static const Tstring desc = "initialize run information in the table.";

TInitializeRunInformationModuleCommand::TInitializeRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, name, desc ), TRunInformationModuleCommand( module )
{;}

TInitializeRunInformationModuleCommand::~TInitializeRunInformationModuleCommand()
{;}

Tvoid TInitializeRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TInitializeRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    theRunInformationModule -> Initialize();
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }
  return;
}
