// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TListCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring name = "/system/ls";
static const Tstring desc = "list up executable commands.\nexample> ls\nexample> ls -a\nexample> ls command";

TListCommand::TListCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TListCommand::~TListCommand()
{;}

Tvoid TListCommand::Execute( const TstringList& arguments )
{
  Tint listmode;
  enum { SIMPLE, DETAIL_ALL, DETAIL_ONE };

  if ( arguments.size() == 0 ) {
    listmode = SIMPLE;
  } else if ( arguments.size() == 1 ) {
    if  ( arguments[ 0 ] == "-a" ) {
      listmode = DETAIL_ALL;
    } else {
      listmode = DETAIL_ONE;
    }
  } else {
    Tcerr << "TListCommand::Execute: invalid arguments" << Tendl;
    ShowCommandDetail();
    listmode = SIMPLE;
  }

  switch ( listmode ) {
    case SIMPLE:
      listSimple();
      break;
    case DETAIL_ALL:
      listDetailAll();
      break;
    case DETAIL_ONE:
      listDetailOne( arguments[ 0 ] );
      break;
    default:
      listSimple();
      break;
  }

  return;
}

Tvoid TListCommand::listSimple() const
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tint ncommand = ui -> GetNumberOfCommands();

  for ( Tint i = 0; i < ncommand; i ++ ) {
    Tcout << ui -> GetCommand( i ) -> GetCommandName();
    if ( i != ncommand - 1 )
      Tcout << Twspace;
  }
  Tcout << Tendl;
  return;
}

Tvoid TListCommand::listDetailAll() const
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  TCommand* com = 0;
  ui -> SetCommandIndex( 0 );
  while ( ( com = ui -> NextCommand() ) )
    com -> ShowCommandDetail();
  return;
}

Tvoid TListCommand::listDetailOne( const Tstring& command ) const
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  TCommand* com = 0;
  com = ui -> FindCommand( command );
  if ( com != 0 ) {
    com -> ShowCommandDetail();
  } else {
    ui -> NotFoundCommand( command );
  }
  return;
}
