// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadFileCommand.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"

static const Tstring name = "/option/readfile";
static const Tstring desc = "open a object file, dump to screen.\nexample> readfile filename.drec";

TReadFileCommand::TReadFileCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TReadFileCommand::~TReadFileCommand()
{;}

Tvoid TReadFileCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  const Tstring filename = arguments[ 0 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  Tint counter = 0;
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize1 += record.GetDataSize();
    datasize2 += ifile -> GetDataSize();
    counter ++;
  }

  Tcout << Tendl;
  Tcout << Ttab << counter << " event, ";
  Tcout << datasize1 << Tslash << datasize2;
  Tcout << " byte data has been read from " << filename << Tendl;
  Tcout << Tendl;

  delete ifile;

  return;
}
