// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSetStackSizeCommand.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"

static const Tstring name = "/event/stacksize";
static const Tstring desc = "set stack size.\nexample> /event/stacksize\nexample> /event/stacksize 1234";

TSetStackSizeCommand::TSetStackSizeCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TSetStackSizeCommand::~TSetStackSizeCommand()
{;}

Tvoid TSetStackSizeCommand::Execute( const TstringList& arguments )
{
  TEventManager* manager = theRunManager -> GetEventManager();

  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring stacksize = arguments[ 0 ];
      manager -> SetStackSize( (Tint)( atoi( stacksize.c_str() ) ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  manager -> SetStackSize( TEventManager::tDefaultStackSize );
  return;
}
