// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TShowRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring name = "/run/showinfo";
static const Tstring desc = "show run information in the table.";

TShowRunInformationModuleCommand::TShowRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, name, desc ), TRunInformationModuleCommand( module )
{;}

TShowRunInformationModuleCommand::~TShowRunInformationModuleCommand()
{;}

Tvoid TShowRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TShowRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }
  TRunInformationTable& table = 
    theRunInformationModule -> GetRunInformationTable();
  if ( table.GetNumberOfRows() > 0 )
    Tcout << table << Tendl;
  return;
}
