// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TEvent.hh"

TEvent::TEvent( Tint eventID )
  : theEventID( eventID ), theDataRecord()
{;}

TEvent::TEvent( const TDataRecord& eventData )
  : theEventID( 0 ), theDataRecord( eventData )
{;}

TEvent::TEvent( Tint eventID, const TDataRecord& eventData )
  : theEventID( eventID ), theDataRecord( eventData )
{;}

TEvent::TEvent( const TEvent& right )
  : theEventID( right.theEventID ), 
    theDataRecord( right.theDataRecord )
{;}

TEvent::~TEvent()
{;}

const TEvent& TEvent::operator=( const TEvent& right )
{
  theEventID = right.theEventID;
  theDataRecord = right.theDataRecord;
  return( *this );
}

Tbool TEvent::operator==( const TEvent& right ) const
{
  if ( theEventID == right.theEventID && theDataRecord == right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TEvent::operator!=( const TEvent& right ) const
{
  if ( theEventID != right.theEventID || theDataRecord != right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TEvent::Clear()
{
  theDataRecord.clear();
  theEventID = 0;
  return;
}

Tstring TEvent::GetEventIDofString() const
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", theEventID );
  Tstring streventid = s;
  delete [] s;
  return( streventid );
}
