// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareFlashAdcModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareFlashAdcModule::TSoftwareFlashAdcModule( Tint nchannel, Tint nsampling, Tint id )
  : TSoftwareModule( nchannel, id ), theNumberOfSampling( nsampling )
{
  setParameters();
  Update();
}

TSoftwareFlashAdcModule::TSoftwareFlashAdcModule( const TSoftwareFlashAdcModule& right )
  : TSoftwareModule( right ), theNumberOfSampling( right.theNumberOfSampling )
{;}

TSoftwareFlashAdcModule::~TSoftwareFlashAdcModule()
{;}

Tint TSoftwareFlashAdcModule::Clear()
{
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareFlashAdcModule::Update()
{
  fillValue();
  return( theStatus );
}

Tint TSoftwareFlashAdcModule::Initialize()
{
  Clear();
  setParameters();
  return( theStatus = tStatusSuccess );
}

Tvoid TSoftwareFlashAdcModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TUshort* data = new TUshort[ theNumberOfSampling ];
    for ( Tint j = 0; j < theNumberOfSampling; j ++ ) {
      data[ j ] = 1234;  //dummy data
    }
    TDataElement element( data, tTypeShort, i, theNumberOfSampling );
    delete [] data;
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TSoftwareFlashAdcModule::FillData( const TDataElement& element )
{
  TUshort* data = new TUshort[ theNumberOfSampling ];

  for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
    data[ i ] = 1234;  //dummy data
  }

  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TSoftwareFlashAdcModule::FillData: invalid ID" << Tendl;
    Tint tmp = -EFAULT;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &tmp, tTypeInt );
  } else {
    ((TDataElement*)(&element)) -> FillData( data, tTypeShort, theNumberOfSampling );
  }

  delete [] data;

  return;
}

const TSoftwareFlashAdcModule& TSoftwareFlashAdcModule::operator=( const TSoftwareFlashAdcModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return( *this );
}

Tbool TSoftwareFlashAdcModule::operator==( const TSoftwareFlashAdcModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return( ret );
}

Tbool TSoftwareFlashAdcModule::operator!=( const TSoftwareFlashAdcModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( theNumberOfSampling != right.theNumberOfSampling );
  return( ret );
}

Tvoid TSoftwareFlashAdcModule::setParameters()
{
  return;
}

Tvoid TSoftwareFlashAdcModule::fillValue()
{
  return;
}
