// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TVmeMpx201aModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TVmeDaughterBoardMemoryModule.hh"

TVmeMpx201aModule::TVmeMpx201aModule( Tint baseaddress, Tint nblock, Tint mapsize )
  : TVmeModule( 0, baseaddress, mapsize, tA16D16 ), theMemoryModule( 0 )
{
  // block counter 1block=2048sample
  SetNumberOfBlock( nblock );

  SetOffsetAddressForDaughterBoard( 0xff00 );

  TUlong offset = GetOffsetAddressForDaughterBoard();


  //new ʤۤ
  //ޥåץϸꡩ
  //ǥץ󥰥졼ȤȤ֥åѤäɤΡ
  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( offset, 0x01000000, nblock * tBlock );

}

TVmeMpx201aModule::TVmeMpx201aModule( const TVmeMpx201aModule& right )
  : TVmeModule( right ), theMemoryModule( 0 )
{

  Tint nblock = right.GetNumberOfBlock();
  SetNumberOfBlock( nblock );

  SetOffsetAddressForDaughterBoard( 0xff00 );

  TUlong offset = GetOffsetAddressForDaughterBoard();
  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( offset, 0x010000000, nblock * tBlock );

}

TVmeMpx201aModule::~TVmeMpx201aModule()
{
  delete theMemoryModule;
}

const TVmeMpx201aModule& TVmeMpx201aModule::operator=( const TVmeMpx201aModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  
  Tint nblock = right.GetNumberOfBlock();
  SetNumberOfBlock( nblock );

  SetOffsetAddressForDaughterBoard( 0xff00 );

  TUlong offset = GetOffsetAddressForDaughterBoard();
  delete theMemoryModule;
  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( offset, 0xf000, nblock * tBlock );

  return( *this );
}

Tbool TVmeMpx201aModule::operator==( const TVmeMpx201aModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  return( ret );
}

Tbool TVmeMpx201aModule::operator!=( const TVmeMpx201aModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  return( ret );
}

Tint TVmeMpx201aModule::Clear()
{
  theMemoryModule -> Clear();
  setBit( (TUshort*)( theModuleBaseAddress + CONTROL_STATUS ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CONTROL_STATUS ), 0, 0 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeMpx201aModule::Update()
{
  return( Clear() );
}

Tint TVmeMpx201aModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeMpx201aModule::FillData( const TDataSegment& segment )
{
  theMemoryModule -> FillData( segment );
  return;
}

Tvoid TVmeMpx201aModule::FillData( const TDataElement& element )
{
  theMemoryModule -> FillData( element );
  return;
}
