// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TCamacModule.hh"

TCamacModule::TCamacModule( Tint nch, Tint baseaddress, Tint mapsize, TCamacTransfer_t mode )
  : TModule( nch, baseaddress ),
    theMappedSize( mapsize ), theTransferMode( mode ),
    theFileDescriptor( -1 ), theModuleBaseAddress( 0 )
{
  theFileDescriptor = open( ( TCamacDevices[ theTransferMode ] ).c_str(), O_RDWR );
  if ( theFileDescriptor == -1 ) {
    perror( "TCamacModule::TCamacModule" );
    exit( EXIT_FAILURE );
  }
  theStatus = errno;


  Tvoid* base = 0;
  if ( ( base = mmap( 0, theMappedSize, PROT_READ|PROT_WRITE, MAP_SHARED, theFileDescriptor, theID ) ) == MAP_FAILED ) {
    perror( "TCamacModule::TCamacModule" );
    exit( EXIT_FAILURE );
  }
  theModuleBaseAddress = (Tcaddr_t)base;  
  theStatus = errno;

}

TCamacModule::TCamacModule( const TCamacModule& right )
  : TModule( right ),
    theMappedSize( right.theMappedSize ),
    theTransferMode( right.theTransferMode ),
    theFileDescriptor( -1 ), theModuleBaseAddress( 0 )
{
  theFileDescriptor = open( ( TCamacDevices[ theTransferMode ] ).c_str(), O_RDWR );
  if ( theFileDescriptor == -1 ) {
    perror( "TCamacModule::TCamacModule" );
    exit( EXIT_FAILURE );
  }
  theStatus = errno;


  Tvoid* base = 0;
  if ( ( base = mmap( 0, theMappedSize, PROT_READ|PROT_WRITE, MAP_SHARED, theFileDescriptor, theID ) ) == MAP_FAILED ) {
    perror( "TCamacModule::TCamacModule" );
    exit( EXIT_FAILURE );
  }
  theModuleBaseAddress = (Tcaddr_t)base;  
  theStatus = errno;
}

TCamacModule::~TCamacModule()
{
  munmap( theModuleBaseAddress, theMappedSize );
  theStatus = errno;
  close( theFileDescriptor );
  theStatus = errno;
}

const TCamacModule& TCamacModule::operator=( const TCamacModule& right )
{
  *( (TModule*)this ) = *( (TModule*)(&right) );
  theMappedSize = right.theMappedSize;
  theTransferMode = right.theTransferMode;
  theFileDescriptor = open( ( TCamacDevices[ theTransferMode ] ).c_str(), O_RDWR );
  if ( theFileDescriptor == -1 ) {
    perror( "TCamacModule::operator=" );
    exit( EXIT_FAILURE );
  }
  theStatus = errno;


  Tvoid* base = 0;
  if ( ( base = mmap( 0, theMappedSize, PROT_READ|PROT_WRITE, MAP_SHARED, theFileDescriptor, theID ) ) == MAP_FAILED ) {
    perror( "TCamacModule::operator=" );
    exit( EXIT_FAILURE );
  }
  theModuleBaseAddress = (Tcaddr_t)base;  
  theStatus = errno;
  return( *this );
}

Tbool TCamacModule::operator==( const TCamacModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TModule*)this ) == *( (TModule*)(&right) ) );
  ret &= ( theMappedSize == right.theMappedSize );
  ret &= ( theTransferMode == right.theTransferMode );
  return( ret );
}

Tbool TCamacModule::operator!=( const TCamacModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TModule*)this ) != *( (TModule*)(&right) ) );
  ret &= ( theMappedSize != right.theMappedSize );
  ret &= ( theTransferMode != right.theTransferMode );
  return( ret );
}

Tvoid TCamacModule::showBit( TUshort data, const Tstring comment ) const
{
  TUshort bit;

  Tcout << "0x";
  Tcout.setf( ios::left );
  Tcout.width( 10 );
  Tcout << hex << data << ": ";
  static const Tint nbits = 16;

  for ( int i = 0; i < nbits; i ++ ) {
    bit = data & 0x8000;
    bit = bit >> ( nbits - 1 );
    Tcout << bit;
    data = data << 1;
  }

  if ( comment.empty() )
    Tcout << Tendl;
  else
    Tcout << "   <--- " << comment << Tendl;

  return;
}

Tvoid TCamacModule::setBit( TUshort* ptr, Tint nbit, Tbit bit )
{
  if ( nbit < 0 || nbit > 15 ) {
    Tcerr << "TCamacModule::setBit: invalid channel" << Tendl;
    return;
  }

  TUshort mask = 0x0001;
  mask = mask << nbit;

  if ( bit == 1 ) {
    *ptr |= mask;
  } else if ( bit == 0 ) {
    mask = ~mask;
    *ptr &= mask;
  } else {
    Tcerr <<  "TCamacModule::setBit: set 0 or 1" << Tendl;
    return;
  }

  return;
}

Tbit TCamacModule::getBit( TUshort* ptr, Tint nbit ) const
{
  if ( nbit < 0 || nbit > 15 ) {
    Tcerr << "TCamacModule::getBit: invalid channel" << Tendl;
    return( 0 );
  }

  TUshort data = *ptr;
  data = data >> nbit;
  data &= 0x00001;

  return( data );
}
