// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TCAMACMODULE_HH
#define __TCAMACMODULE_HH

#include "TGlobals.hh"
#include "TModule.hh"

class TCamacModule
  : public TModule
{

  protected:
    Tsize_t theMappedSize;
    TCamacTransfer_t theTransferMode;
    Tint theFileDescriptor;
    Tcaddr_t theModuleBaseAddress;

  public:
    TCamacModule( Tint nch, Tint baseaddress, Tint mapsize, TCamacTransfer_t mode );
    TCamacModule( const TCamacModule& right );

  protected:
    virtual ~TCamacModule();

  public:
    virtual const TCamacModule& operator=( const TCamacModule& right );
    virtual Tbool operator==( const TCamacModule& right ) const;
    virtual Tbool operator!=( const TCamacModule& right ) const;

  public:
    Tsize_t GetMappedSize() const;
    TvmeTransfer_t GetTransferMode() const;
    Tint GetFileDescriptor() const;
    Tcaddr_t GetModuleBaseAddress() const;

    Tvoid SetMappedSize( Tsize_t mapsize );
    Tvoid SetTransferMode( TvmeTransfer_t mode );
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetModuleBaseAddress( Tcaddr_t address );

  protected:
    Tvoid showBit( TUshort data, const Tstring comment = "" ) const;
    Tvoid setBit( TUshort* ptr, Tint nbit, Tbit bit );
    Tbit getBit( TUshort* ptr, Tint nbit ) const;

};

inline Tsize_t TCamacModule::GetMappedSize() const
{
  return( theMappedSize );
}

inline TCamacTransfer_t TCamacModule::GetTransferMode() const
{
  return( theTransferMode );
}

inline Tint TCamacModule::GetFileDescriptor() const
{
  return( theFileDescriptor );
}

inline Tcaddr_t TCamacModule::GetModuleBaseAddress() const
{
  return( theModuleBaseAddress );
}

inline Tvoid TCamacModule::SetMappedSize( Tsize_t mapsize )
{
  theMappedSize = mapsize;
  return;
}

inline Tvoid TCamacModule::SetTransferMode( TvmeTransfer_t mode )
{
  theTransferMode = mode;
  return;
}

inline Tvoid TCamacModule::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TCamacModule::SetModuleBaseAddress( Tcaddr_t address )
{
  theModuleBaseAddress = address;
  return;
}

#endif
