// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOUTPUTOBJECTSOCKET_HH
#define __TOUTPUTOBJECTSOCKET_HH

#include "TGlobals.hh"
#include "TObjectSocket.hh"
#include "TOutputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TOutputObjectSocket
  : public TObjectSocket, public TOutputObjectStream
{

  private:
    Tstring theServerName;
    struct hostent* theHostInformation;

  public:
    TOutputObjectSocket( const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( Tint port );
    TOutputObjectSocket( TObjectFilter* filter, const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( TObjectFilter* filter, Tint port );
    ~TOutputObjectSocket();

  public:
    Tint WriteData( TStreamableObject& object );

  public:
    const Tstring& GetServerName() const;

  private:
    Tvoid initialize();

};

inline const Tstring& TOutputObjectSocket::GetServerName() const
{
  return( theServerName );
}

#endif
