// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareDataFileModule.hh"
#include "TOutputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  TOutputObjectFile* ofile = new TOutputObjectFile( filename );
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  const Tstring datafile = "g4data.dat";
  const Tint nchannel = 2;

  TSoftwareDataFileModule g4data( datafile, nchannel );

  TReadoutList list( 1000 );
  TReadoutSection sec( 1100 );
  TReadoutSegment seg( &g4data, 1100 );
  sec.push_back( seg );
  list.push_back( sec );

  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = list.ReadData();
    ofile -> WriteData( record );
    datasize1 += record.GetDataSize();
    datasize2 += ofile -> GetDataSize();
    Tcout << record << Tendl;
    g4data.Update();
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize1 << Tslash << datasize2;
  Tcout << Tspace << "byte data has been written down " << filename << Tendl;
  Tcout << Ttab << "number of available line as data: " << g4data.GetNumberOfLine() << Tendl;
  Tcout << Tendl;

  delete ofile;

  return( 0 );
}
