// ============================================================================
//  $Id: AsoStartCommand.cc,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#include "AsoStartCommand.hh"
#include "AsoReadoutList.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"
#include "TOutputObjectFile.hh"

static const Tstring name = "aso-start";
static const Tstring desc = "ɤѤΥǡ򳫻Ϥޤ\nΥޥɤϾŪˤstartޥɤ˵ۼΤפˤʤޤ";


AsoStartCommand::AsoStartCommand()
  : TCommand( name, desc ), theReadoutList( 0 )
{
  theReadoutList = new AsoReadoutList();
}

AsoStartCommand::~AsoStartCommand()
{
  delete theReadoutList;
}

Tvoid AsoStartCommand::Execute( const TstringList& arguments )
{
  const Tint nevents = 100;

  TVmeMpx201aModule* mpx201a = theReadoutList -> GetFadc();
  mpx201a -> Clear();
  const Tint rpv130base = 0x1000;
  TVmeRpv130Module rpv130( rpv130base );
  rpv130.LevelUp();


  mpx201a -> SetSamplingRate( 15 );  // 1/16
  //mpx201a -> SetSamplingRate( 0 );  // 1/1




  mpx201a -> SetDataCaptureMode( TVmeMpx201aModule::tTransientMode );
  mpx201a -> SetEventSynchronisationMode( TVmeMpx201aModule::tExternalSynchronisationMode );
  mpx201a -> EnableAccessToDaughterBoard();

  const Tstring filename = "aso-ccd.obj";
  TOutputObjectFile* ofile = new TOutputObjectFile( filename );

  rpv130.Pulse( 1 );
  rpv130.LevelDown( 0 );

  for ( Tint i = 0; i < nevents; i ++ ) {
    Tcout << "### event " << i << Tendl;

    mpx201a -> EnableAcquisition();
    rpv130.LevelUp( 0 );

    Tint nsleep = 0;

    while ( 1 ) {

      if ( mpx201a -> IsMemoryBlockFull() ) {
	Tcout << "### data filled." << Tendl;
	theReadoutList -> GetScaler() -> Update();
	theReadoutList -> GetClock() -> Update();
	
	mpx201a -> SetBufferOrientation( 1 );

	TDataRecord record = theReadoutList -> ReadData();
	//Tcout << record << endl;


	rpv130.Pulse( 1 );
	rpv130.Pulse( 3 );
	rpv130.LevelDown( 0 );


	ofile -> WriteData( record );


	mpx201a -> DisableAcquisition();
	mpx201a -> SetMemoryBlockFullFlag( 0 );
	mpx201a -> SetDataOverFlowFlag( 0 );
	mpx201a -> EnableSystemFailure();
	mpx201a -> SetScanCompleteFlag( 0 );

	break;
      } else {
	Tcout << "no data: " << nsleep << " times sleep." << Tendl;
	sleep( 1 );
	nsleep ++;
	if ( nsleep > 30 ) {
	  Tcout << "### event #" << i << ": no data taking." << Tendl;
	  break;
	}
      }
    }


  }

  delete ofile;
  return;
}
