// ============================================================================
//  $Id: BtRunAction.hh,v 1.5 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTRUNACTION_HH
#define __BTRUNACTION_HH

#include "TGlobals.hh"
#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class BtModuleManager;
class TInputObjectFile;
class BtRunSummary;
class TDataRecord;

class BtRunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TInputObjectFile* theInputFile;
    BtModuleManager* theModuleManager;
    TOutputHtmlFileStream theOutputHtml;
    BtRunSummary* theRunSummary;

  public:
    BtRunAction( BtModuleManager* manager );
    ~BtRunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

    TOutputObjectFile* GetOutputFile() const;
    TInputObjectFile* GetInputFile() const;
    BtRunSummary* GetRunSummary() const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* BtRunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline TInputObjectFile* BtRunAction::GetInputFile() const
{
  return( theInputFile );
}

inline BtRunSummary* BtRunAction::GetRunSummary() const
{
  return( theRunSummary );
}

#endif
