// ============================================================================
//  $Id: BtRunSummary.cc,v 1.4 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtRunSummary.hh"
#include "parameter.h"

BtRunSummary::BtRunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfCsIEvents( 0 ), 
    theNumberOfScalerEvents( 0 ),
    theNumberOfAllEvents( 0 ),
    theRunInformationTable(),
    theAccumulatedScaler( BTscaler_nch, 0 ),
    theRunBeginTime(),
    theRunEndTime()
{;}

BtRunSummary::~BtRunSummary()
{;}

Tvoid BtRunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfCsIEvents = 0; 
  theNumberOfScalerEvents = 0;
  theNumberOfAllEvents = 0;
  theRunInformationTable = TRunInformationTable();
  theAccumulatedScaler = TChannel( BTscaler_nch, 0 );
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable BtRunSummary::GenerateRunInformationTable() const
{
  TstringList itemlist;
  itemlist.clear();

  TstringList valuelist;
  valuelist.clear();

  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  Tstring strbuf;

  // END OF ITEM DEFINITION
  itemlist.push_back( "Run ID" );
  itemlist.push_back( "Identification of object file" );
  itemlist.push_back( "Size of object file" );
  itemlist.push_back( "Run Start" );
  itemlist.push_back( "Run Stop" );
  itemlist.push_back( "Number of CsI events" );
  itemlist.push_back( "Number of Scaler events" );
  itemlist.push_back( "Number of <font color=#ff0000>All</font> events" );
  for ( Tsize_t i = 0; i < theRunInformationTable.GetItemList().size(); i ++ ) {
    strbuf = "Run information (";
    strbuf += ( theRunInformationTable.GetItemList() )[ i ];
    strbuf += ")";
    itemlist.push_back( strbuf );
  }
  itemlist.push_back( "Accumulated scaler counts (PIN1)" );
  itemlist.push_back( "Accumulated scaler counts (PIN2)" );
  itemlist.push_back( "Accumulated scaler counts (PIN3)" );
  itemlist.push_back( "Accumulated scaler counts (PIN4)" );
  itemlist.push_back( "Accumulated scaler counts (PIN5)" );
  itemlist.push_back( "Accumulated scaler counts (TRG1)" );
  itemlist.push_back( "Accumulated scaler counts (TRG2)" );
  itemlist.push_back( "Accumulated scaler counts (****)" );
  // END OF ITEM DEFINITION



  // BEGIN OF VALUE DEFINITION
  snprintf( s, maxlen, "%d", theRunID );
  strbuf = s;
  valuelist.push_back( strbuf );

  valuelist.push_back( theRecordName );

  snprintf( s, maxlen, "%d", theRecordSize );
  strbuf = s;
  valuelist.push_back( strbuf );

  valuelist.push_back( theRunBeginTime );

  valuelist.push_back( theRunEndTime );

  snprintf( s, maxlen, "%d", theNumberOfCsIEvents );
  strbuf = s;
  valuelist.push_back( strbuf );

  snprintf( s, maxlen, "%d", theNumberOfScalerEvents );
  strbuf = s;
  valuelist.push_back( strbuf );

  snprintf( s, maxlen, "%d", theNumberOfAllEvents );
  strbuf = s;
  valuelist.push_back( strbuf );

  for ( Tsize_t i = 0; i < theRunInformationTable.GetValueList().size(); i ++ ) {
    valuelist.push_back( ( theRunInformationTable.GetValueList() )[ i ] );
  }

  for ( Tsize_t i = 0; i < theAccumulatedScaler.size(); i ++ ) {
    snprintf( s, maxlen, "%d", theAccumulatedScaler[ i ] );
    strbuf = s;
    valuelist.push_back( strbuf );
  }
  // BEGIN OF VALUE DEFINITION


  delete [] s;

  TRunInformationTable table( itemlist, valuelist );
  return( table );
}
