// ============================================================================
//  $Id: eventview.cc,v 1.2 2002/12/09 07:32:34 iwai Exp $
//  $Name:  $
// ============================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "parameter.h"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"


TCanvas* canvas1 = 0;
TCanvas* canvas2 = 0;
TH1S* adchist = 0;
TH1S* scalerhist = 0;

static Tint nadc = 0;
static Tint nscaler = 0;

Tvoid doCsIEventView( const TDataRecord& record );
Tvoid doScalerEventView( const TDataRecord& record );

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }


  TApplication* theApp = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );


  Tstring filename = argv[ 1 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  TDataRecord record;


  Tstring rootfiles = "/home/beamtest/rootfiles";
  Tstring rootext = ".root";
  Tstring rofilename = filename.replace( 0, 25, rootfiles );
  rofilename = rofilename.replace( 31, 5, rootext );
  TFile* rootf = new TFile( rofilename.c_str(), "recreate", rofilename.c_str() );


  Tstring psfiles = "/home/beamtest/psfiles";
  Tstring adcext = "-adc.ps";
  Tstring sclext = "-scaler.ps";
  Tstring adcps = filename.replace( 0, 24, psfiles );
  adcps = adcps.replace( 29, 5, adcext );
  Tstring sclps = filename.replace( 0, 22, psfiles );
  sclps = sclps.replace( 29, 5, sclext );



  canvas1 = new TCanvas( "adc", "ADC #0" );
  gPad -> SetGrid();
  gStyle -> SetOptStat( 1111111 );
  canvas2 = new TCanvas( "scaler", "SCALER #0-7" );
  gPad -> SetGrid();
  //adchist = new TH1S( "ADC 1DHISTO", "ADC #0", 4095, 0, 4095 );
  adchist = new TH1S( "adc1Dhisto", "ADC #0", 400, 0, 4095 );
  scalerhist = new TH1S( "scaler1Dhisto", "SCALER #0-7", 10, -1, 9 );

  while ( ifile -> ReadData( record ) != 0 ) {

    

    Tint recid = record.GetID();
    if ( recid == BTevent ) {
      doCsIEventView( record );
    } else if ( recid == BTscalerevent ) {
      doScalerEventView( record );
    } else if ( recid == BTrunend ) {
      break;
    } else if ( recid == BTrunbegin ) {
      continue;
    } else {
      //Tcerr << "danger! unknown event." << Tendl;
      continue;
    }

    //gSystem -> ProcessEvents();

  }


  canvas1 -> cd();
  adchist -> Draw();
  canvas1 -> Modified();
  canvas1 -> Update();
  canvas1 -> Print(adcps.c_str());

  canvas2 -> cd();
  scalerhist -> Draw();
  canvas2 -> SetLogy();
  canvas2 -> Modified();
  canvas2 -> Update();
  canvas2 -> Print(sclps.c_str());

  rootf -> Write();
  delete ifile;



  //theApp -> Run();


  rootf -> Close();
  delete rootf;


  return( 0 );
}

Tvoid doCsIEventView( const TDataRecord& record )
{
  TDataSection section = record[ 0 ];
  TDataSegment segment = section[ 1 ];
  TDataElement element = segment[ 0 ];

  TUint cnt = *( (TUint*)( element.GetData() ) );

  adchist -> Fill( cnt );


  //if ( nadc % 100 == 0 ) {

    //canvas1 -> Modified();
    //canvas1 -> Update();
    //}


  nadc ++;
  return;
}

Tvoid doScalerEventView( const TDataRecord& record )
{
  TDataSection section = record[ 0 ];
  TDataSegment segment = section[ 1 ];

  TDataElement ch0 = segment[ 0 ];
  TDataElement ch1 = segment[ 1 ];
  TDataElement ch2 = segment[ 2 ];
  TDataElement ch3 = segment[ 3 ];
  TDataElement ch4 = segment[ 4 ];
  TDataElement ch5 = segment[ 5 ];
  TDataElement ch6 = segment[ 6 ];
  TDataElement ch7 = segment[ 7 ];

  TUint cnt0 = *( (TUint*)( ch0.GetData() ) );
  TUint cnt1 = *( (TUint*)( ch1.GetData() ) );
  TUint cnt2 = *( (TUint*)( ch2.GetData() ) );
  TUint cnt3 = *( (TUint*)( ch3.GetData() ) );
  TUint cnt4 = *( (TUint*)( ch4.GetData() ) );
  TUint cnt5 = *( (TUint*)( ch5.GetData() ) );
  TUint cnt6 = *( (TUint*)( ch6.GetData() ) );
  TUint cnt7 = *( (TUint*)( ch7.GetData() ) );

  //canvas2 -> cd();
  scalerhist -> Fill( (Tdouble)0, (Tdouble)cnt0 );
  scalerhist -> Fill( (Tdouble)1, (Tdouble)cnt1 );
  scalerhist -> Fill( (Tdouble)2, (double)cnt2 );
  scalerhist -> Fill( (Tdouble)3, (double)cnt3 );
  scalerhist -> Fill( (Tdouble)4, (double)cnt4 );
  scalerhist -> Fill( (Tdouble)5, (double)cnt5 );
  scalerhist -> Fill( (Tdouble)6, (double)cnt6 );
  scalerhist -> Fill( (Tdouble)7, (double)cnt7 );


  //if ( nscaler % 10 == 0 ) {
  //scalerhist -> Draw();
  //canvas2 -> Modified();
  //canvas2 -> Update();
  //}

  nscaler ++;


  return;
}
