// ============================================================================
//  $Id: DummyEventAction.cc,v 1.2 2002/12/07 13:13:49 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "DummyEventAction.hh"
#include "DummyRunAction.hh"

DummyEventAction::DummyEventAction( DummyModuleDefinition* definition )
  : theModuleDefinition( definition )
{;}

DummyEventAction::~DummyEventAction()
{;}

const TReadoutList& DummyEventAction::WaitEvent()
{
  // random trigger with sleep
  struct timespec req;
  Tlong rnd = lrand48();
  req.tv_sec = 0;
  req.tv_nsec = rnd;
  nanosleep( &req, 0 );

  return( theModuleDefinition -> GetReadoutList() );
}

Tvoid DummyEventAction::BeginOfEventAction( TEvent& anEvent )
{
  //begin -> (update) -> wait -> read -> end
  theModuleDefinition -> Update();
  return;
}

Tvoid DummyEventAction::EndOfEventAction( TEvent& anEvent )
{
  DummyRunAction* action =
    (DummyRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  ofile -> WriteData( anEvent.GetDataRecord() );

  return;
}
