// ============================================================================
//  $Id: DummyModuleDefinition.hh,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __DUMMYMODULEDEFINITION_HH
#define __DUMMYMODULEDEFINITION_HH

#include "TReadoutList.hh"
#include "TReadoutList.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareFlashAdcModule.hh"
#include "TSoftwareRunInformationModule.hh"

class TReadoutList;
class TSoftwareScalerModule;
class TSoftwareTimerModule;
class TSoftwareClockModule;
class TSoftwareFlashAdcModule;

class DummyModuleDefinition
{

  private:
    TReadoutList theReadoutList1;
    TReadoutList theReadoutList2;
    TSoftwareScalerModule theScaler;
    TSoftwareTimerModule theTimer;
    TSoftwareClockModule theClock;
    TSoftwareFlashAdcModule theFlashAdc;
    TSoftwareRunInformationModule* theRunInfo;

  public:
    DummyModuleDefinition();
    ~DummyModuleDefinition();

  public:
    const TReadoutList& GetReadoutList() const;
    Tvoid Update();
    TSoftwareRunInformationModule* GetRunInfo() const;

};

inline TSoftwareRunInformationModule* DummyModuleDefinition::GetRunInfo() const
{
  return( theRunInfo );
}

#endif
