// ============================================================================
//  $Id: TAnalysisSuspendCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TAnalysisSuspendCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring name = "/analysis/suspend";
static const Tstring desc = "suspend an analysis.";

TAnalysisSuspendCommand::TAnalysisSuspendCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, name, desc ), TAnalysisCommand( anaman )
{;}

TAnalysisSuspendCommand::~TAnalysisSuspendCommand()
{;}

Tvoid TAnalysisSuspendCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> SuspendAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> SuspendAnalysis( arguments[ i ] );
  }
  return;
}
