// ============================================================================
//  $Id: TExitCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TExitCommand.hh"
#include "TUserInterface.hh"
#include "TRunManager.hh"

static const Tstring name = "exit";
static const Tstring desc = "terminate this session by force.";

TExitCommand::TExitCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TExitCommand::~TExitCommand()
{;}

Tvoid TExitCommand::Execute( const TstringList& arguments )
{
  Tstatus_t status = theRunManager -> GetStatus();
  switch ( status ) {
    case tStatusStandby:
      theRunManager -> ShutdownRun();
      break;
    case tStatusReady:
      theRunManager -> SuspendRun();
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusBusy:
      theRunManager -> SuspendRun();
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusIdle:
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusWaitingReady:
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    default:
      break;
  }
  return;
}
