// ============================================================================
//  $Id: THelpCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "THelpCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring name = "help";
static const Tstring desc = "print a detail of command given as argument.";

THelpCommand::THelpCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

THelpCommand::~THelpCommand()
{;}

Tvoid THelpCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();
  TCommand* com = 0;
  com = ui -> FindCommand( arguments[ 0 ] );
  if ( com != 0 ) {
    com -> ShowCommandDetail();
  } else {
    ui -> NotFoundCommand( arguments[ 0 ] );
  }

  return;
}
