// ============================================================================
//  $Id: TDataSegment.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATASEGMENT_HH
#define __TDATASEGMENT_HH

#include "TGlobals.hh"
#include "TStreamableObject.hh"
#include "TDataElementList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSegment
  : public TStreamableObject, public TDataElementList
{

  public:
    TDataSegment( Tint id = tIDunknown );
    TDataSegment( const TDataSegment& right );
    ~TDataSegment();

    Tint GetDataSize();
    Tint WriteData( TOutputObjectStream* output );

  public:
    const TDataSegment& operator=( const TDataSegment& right );
    Tbool operator==( const TDataSegment& right ) const;
    Tbool operator!=( const TDataSegment& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataSegment& right );

  private:
    Tint writeToFile( TOutputObjectFile* ofile );
    Tint writeToSocket( TOutputObjectSocket* osocket );
    Tint writeToSharedMemory( TOutputObjectSharedMemory* omemory );


};

#endif
