// ============================================================================
//  $Id: TUserInterface.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TUSERINTERFACE_HH
#define __TUSERINTERFACE_HH

#include "TGlobals.hh"

class TCommand;

class TUserInterface
{

  protected:
    TCommand** theCommandList;
    Tint theCommandListCapacity;
    Tint theNumberOfCommands;
    Tint theCommandIndex;
    Tofstream theHistoryFileStream;

  public:
    Tint AddCommand( TCommand* command );
    Tint RemoveCommand( Tint index );
    Tvoid ClearCommandList();
    Tbool ResizeCommandList( Tint capacity );
    TCommand* NextCommand();
    TCommand* FindCommand( const Tstring& command );
    TCommand* GetCommand( Tint index );
    TCommand* GetCommand();
    Tvoid ExecuteCommand( const Tstring& command, const TstringList& arguments );
    Tvoid ExecuteCommand( const Tstring& command );

  public:
    Tint GetCommandListCapacity() const;
    Tint GetNumberOfCommands() const;
    Tint GetCommandIndex() const;
    Tvoid SetCommandIndex( Tint index );
    Tofstream& GetHistoryFileStream();

  protected:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    TUserInterface( const Tstring& history = "history.last" );
    virtual ~TUserInterface();

  public:
    virtual Tbool AcceptCommand() = 0;
    virtual const Tstring& GetInputCommand() = 0;

  public:
    virtual Tvoid NotFoundCommand( const Tstring& commandname ) const;

};

inline Tint TUserInterface::GetCommandListCapacity() const
{
  return( theCommandListCapacity );
}

inline Tint TUserInterface::GetNumberOfCommands() const
{
  return( theNumberOfCommands );
}

inline Tint TUserInterface::GetCommandIndex() const
{
  return( theCommandIndex );
}

inline Tvoid TUserInterface::SetCommandIndex( Tint index )
{
  theCommandIndex = index;
  return;
}

inline Tofstream& TUserInterface::GetHistoryFileStream()
{
  return( theHistoryFileStream );
}

#endif
