// ============================================================================
//  $Id: TCamacScalerModule.cc,v 1.3 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacScalerModule::TCamacScalerModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacScalerModule::TCamacScalerModule( const TCamacScalerModule& right )
  : TCamacModule( right )
{;}

TCamacScalerModule::~TCamacScalerModule()
{;}

const TCamacScalerModule& TCamacScalerModule::operator=( const TCamacScalerModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacScalerModule::operator==( const TCamacScalerModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
  return( retval );
}

Tbool TCamacScalerModule::operator!=( const TCamacScalerModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
  return( retval );
}

Tvoid TCamacScalerModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Read( i );
    //if ( theQ == 1 && theX == 1 ) {
    TDataElement element( &theCamacData, tTypeUnsignedInt, i, 1 );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
    //} else {
    //Tstring head = "TCamacScalerModule::FillData: ";
    //perror( head.c_str() );
    //Tcerr << head << "Q=" << theQ << " X=" << theX << " Status=" << theStatus << Tendl;
    //Tcerr << head << "status is filled." << Tendl;
    //TDataElement element( &theStatus, tTypeInt, i, 1 );
    //( (TDataElementList*)(&segment) ) -> push_back( element );
    //}
  }
  return;
}

Tvoid TCamacScalerModule::FillData( const TDataElement& element )
{
  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TCamacScalerModule::FillData: invalid ID" << Tendl;
    ( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read();
    //if ( theQ == 1 && theX == 1 ) {
    ( (TDataElement*)(&element) ) -> FillData( &theCamacData, tTypeUnsignedInt, 1 );
    //} else {
    //Tstring head = "TCamacScalerModule::FillData: ";
    //perror( head.c_str() );
    //Tcerr << head << "Q=" << theQ << " X=" << theX << " Status=" << theStatus << Tendl;
    //Tcerr << head << "status is filled." << Tendl;
    //( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt );
    //}
  }
  return;
}

Tint TCamacScalerModule::ReadOverflowChannel()
{
  return( execute( 0, 1 ) );
}

Tint TCamacScalerModule::ClearOverflowChannel()
{
  return( execute( 0, 10 ) );
}

Tint TCamacScalerModule::IncrementAllChannel()
{
  return( execute( 0, 25 ) );
}

Tint TCamacScalerModule::Clear()
{
  ClearOverflowChannel();
  return( execute( 0, tCamacClear ) );
}

Tint TCamacScalerModule::Update()
{
  return( Clear() );
}

Tint TCamacScalerModule::Initialize()
{
  return( Clear() );  
}
