// ============================================================================
//  $Id: TModule.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TMODULE_HH
#define __TMODULE_HH

#include "TGlobals.hh"

class TDataSegment;
class TDataElement;

class TModule
{

  protected:
    enum { tStatusSuccess = 0 };

  protected:
    Tint theNumberOfChannels;
    Tint theID;
    Tint theStatus;

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;
    virtual Tvoid FillData( const TDataSegment& segment ) = 0;
    virtual Tvoid FillData( const TDataElement& element ) = 0;

  public:
    TModule( Tint nchannel = 0, Tint id = tIDunknown );
    TModule( const TModule& right );

  protected:
    virtual ~TModule();

  public:
    virtual const TModule& operator=( const TModule& right );
    virtual Tbool operator==( const TModule& right ) const;
    virtual Tbool operator!=( const TModule& right ) const;

  public:
    Tint GetNumberOfChannels() const;
    Tint GetStatus() const;
    Tint GetID() const;
    Tvoid SetNumberOfChannels( Tint nchannel );
    Tvoid SetStatus( Tint status );
    Tvoid SetID( Tint id );

    Tbool IsSuccess() const;

};

inline Tint TModule::GetNumberOfChannels() const
{
  return( theNumberOfChannels );
}

inline Tvoid TModule::SetNumberOfChannels( Tint nchannel )
{
  theNumberOfChannels = nchannel;
  return;
}

inline Tint TModule::GetID() const
{
  return( theID );
}

inline Tvoid TModule::SetID( Tint id )
{
  theID = id;
  return;
}

inline Tint TModule::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TModule::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TModule::IsSuccess() const
{
  return( ( theStatus >= 0 ) ? Ttrue : Tfalse );
}

#endif
