// ============================================================================
//  $Id: TSoftwareFlashAdcModule.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSOFTWAREFLASHADCMODULE_HH
#define __TSOFTWAREFLASHADCMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareFlashAdcModule
  : public TSoftwareModule
{

  private:
    enum { tDefaultSampling = 62500 };
    enum { tDefaultChannel = 1 };

  private:
    Tint theNumberOfSampling;

  public:
    TSoftwareFlashAdcModule( Tint nchannel = tDefaultChannel, Tint nsampling = tDefaultSampling, Tint id = tIDunknown );
    TSoftwareFlashAdcModule( const TSoftwareFlashAdcModule& right ); 
   ~TSoftwareFlashAdcModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  public:
    const TSoftwareFlashAdcModule& operator=( const TSoftwareFlashAdcModule& right );
    Tbool operator==( const TSoftwareFlashAdcModule& right ) const;
    Tbool operator!=( const TSoftwareFlashAdcModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsampling );

  protected:
    Tvoid setParameters();
    Tvoid fillValue();

};

inline Tint TSoftwareFlashAdcModule::GetNumberOfSampling() const
{
  return( theNumberOfSampling );
}

inline Tvoid TSoftwareFlashAdcModule::SetNumberOfSampling( Tint nsampling )
{
  theNumberOfSampling = nsampling;
  return;
}

#endif
