// ============================================================================
//  $Id: TSoftwareTimerModule.cc,v 1.3 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSoftwareTimerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareTimerModule::TSoftwareTimerModule( const Tstring& unit, Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, id ), 
    theIntervalTime( 0.0 ), theCurrentTime( 0.0 ), thePreviousTime( 0.0 )
{
  if ( unit == Tsec || unit == Tmsec || unit == Tusec )
    theUnit = unit;
  else {
    Tstring head = "TSoftwareTimerModule::TSoftwareTimerModule: ";
    Tcerr << head << "invalid unit" << Tendl;
    Tcerr << head << "[" << Tmsec << "]" << " use" << Tendl;
    theUnit = Tmsec;
  }

  if ( nchannel > tNumberOfChannels ) {
    Tstring head = "TSoftwareTimerModule::TSoftwareTimerModule: ";
    Tcerr << head << "invalid channels" << Tendl;
    Tcerr << head << "revised " << tNumberOfChannels << Tendl;
    theNumberOfChannels = tNumberOfChannels;
  }
  setCurrentTime();
  Update();
}

TSoftwareTimerModule::TSoftwareTimerModule( const TSoftwareTimerModule& right )
  : TSoftwareModule( right ), 
    theIntervalTime( right.theIntervalTime ),
    theCurrentTime( right.theCurrentTime ),
    thePreviousTime( right.thePreviousTime ),
    theUnit( right.theUnit )
{;}

TSoftwareTimerModule::~TSoftwareTimerModule()
{;}

Tvoid TSoftwareTimerModule::FillData( const TDataSegment& segment )
{
  Update();
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    if ( i == tIntervalTime ) {
      TDataElement element( &theIntervalTime, tTypeDouble, tIntervalTime );
      ((TDataElementList*)(&segment)) -> push_back( element );
    } else if ( i == tCurrentTime ) {
      TDataElement element( &theCurrentTime, tTypeDouble, tCurrentTime );
      ((TDataElementList*)(&segment)) -> push_back( element );
    } else if ( i == tPreviousTime ) {
      TDataElement element( &thePreviousTime, tTypeDouble, tPreviousTime );
      ((TDataElementList*)(&segment)) -> push_back( element );
    } else if ( i == tUnit ) {
      TDataElement element( &theUnit, tTypeString, tUnit );
      ((TDataElementList*)(&segment)) -> push_back( element );
    }
  }
  return;
}

Tvoid TSoftwareTimerModule::FillData( const TDataElement& element )
{
  Update();

  Tint ch = element.GetID();
  Tint tmp = -EFAULT;

  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TSoftwareScalerModule::FillData: invalid ID" << Tendl;
    ((TDataElement*)(&element)) -> FillData( &tmp, tTypeInt );
  } else if ( ch == tIntervalTime ) {
    ((TDataElement*)(&element)) -> FillData( &theIntervalTime, tTypeDouble );
  } else if ( ch == tCurrentTime ) {
    ((TDataElement*)(&element)) -> FillData( &theCurrentTime, tTypeDouble );
  } else if ( ch == tPreviousTime ) {
    ((TDataElement*)(&element)) -> FillData( &thePreviousTime, tTypeDouble );
  } else if ( ch == tUnit ) {
    ((TDataElement*)(&element)) -> FillData( &theUnit, tTypeString );
  }

  return;
}

const TSoftwareTimerModule& TSoftwareTimerModule::operator=( const TSoftwareTimerModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theIntervalTime = right.theIntervalTime;
  theCurrentTime = right.theCurrentTime;
  thePreviousTime = right.thePreviousTime;
  theUnit = right.theUnit;
  return( *this );
}

Tbool TSoftwareTimerModule::operator==( const TSoftwareTimerModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theIntervalTime == right.theIntervalTime );
  ret &= ( theCurrentTime == right.theCurrentTime );
  ret &= ( thePreviousTime == right.thePreviousTime );
  ret &= ( theUnit == right.theUnit );
  return( ret );
}

Tbool TSoftwareTimerModule::operator!=( const TSoftwareTimerModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( theIntervalTime != right.theIntervalTime );
  ret |= ( theCurrentTime != right.theCurrentTime );
  ret |= ( thePreviousTime != right.thePreviousTime );
  ret |= ( theUnit != right.theUnit );
  return( ret );
}

Tvoid TSoftwareTimerModule::setCurrentTime()
{
  thePreviousTime = theCurrentTime;

  struct timeval now;
  gettimeofday( &now, 0 );

  Tdouble tv_sec = (Tdouble)( now.tv_sec );
  Tdouble tv_usec = (Tdouble)( now.tv_usec );

  Tdouble usec = ( tv_sec * 1.0e+6 ) + tv_usec;

  if ( theUnit == Tsec )
    theCurrentTime = usec * 1.0e-6;
  else if ( theUnit == Tmsec )
    theCurrentTime = usec * 1.0e-3;
  else if ( theUnit == Tusec )
    theCurrentTime = usec;

  theIntervalTime = theCurrentTime - thePreviousTime;
  if ( theIntervalTime < 0 )
    theIntervalTime = (Tdouble)( -EFAULT );

  return;
}
